
skt=sktopen('192.168.1.4');

 STM32F103_bitfields; % Get some bitfields
 %%Calibration Bits%%%
% Calibration initial match for rload only
  Vcal= 1*exp(-7*i*pi/180); % Compensate for phase angle into voltage input vs current with resistive load
  Ical= 1;      % Note the 1 in Vcal and Ical can be used to change non frequency sensitive gain issues - or use ADC_Scale
  ADC_Scale = [248.34 0; 0 24];  % from Arlie
  Radc=1000;   % For calcullation of atten
  Cadc=11e-12; % For calcullation of atten
%% end of calibration bits
  setenv('XDG_SESSION_TYPE','x11');
Vtemp=0;
  SRATE_MAX=875000;

  if (size(findname(skt.name,"ADC_Scale"))>0)
   ADC_Scale=udpget(skt,'ADC_Scale');
  endif
  if (size(findname(skt.name,"Vcal"))>0)
   Vcal=udpget(skt,'Vcal')*[1 ; i];
  endif
  if (size(findname(skt.name,"Ical"))>0)
   Ical=udpget(skt,'Ical')*[1 ; i];
  endif
  if (size(findname(skt.name,"ADC_RC"))>0)
   ADC_RC=udpget(skt,'ADC_RC');
  else
   ADC_RC=Radc*Cadc;
  endif

   if (size(findname(skt.name,"tfoc"))>0)
   tfocs=udpget(skt,'tfoc');
   tfoc=tfocs(1)+i*tfocs(2);
  else
   tfoc=0;
  endif
  if (size(findname(skt.name,"tfsc"))>0)
   tfscs=udpget(skt,'tfsc');
   tfsc=tfscs(1)+i*tfscs(2);
  else
   tfsc=0;
  endif
%STM32F103_ADC_SETUP(skt,[1;0],6750000/8);


  Imp_Filt=0.1;
  Imp_Ave_sxy=0.0;
  Imp_Ave_sxx=0.0;
  Imp_Ave=0.0;
  Pow_Ave=0.0;
  Raw_Imp_Ave_sxy=0.0;
  Raw_Imp_Ave_sxx=0.0;
  Raw_Imp_Ave=0.0;
  Raw_Pow_Ave=0.0;




udpset(skt,'DoTheDFT',1);
udp_bit_set(skt,"TIM3_CR1",CEN);
plotlen=1001;

a=udpget(skt,'DFT_Res');
volts=a(1:2)*[1;i];
amps=a(3:4)*[1;i];

f=a(5);
oldf=ones(5,1)*f;
if (f<1e6)
  f=median(oldf);
else
  oldf(2:5)=oldf(1:4);
  oldf(1)=f;
endif



vd=20*log10(abs(volts));
id=20*log10(abs(amps));
r=ones(2,plotlen);
r=[vd 0; 0 id]*r;
figure(1)
p=  plot(0:(plotlen-1),r');
grid on
ylabel('dB re 1 volt or 1 amp');

pstr=[
sprintf('Dft Res,freq = %7.0f Hz   DFT Count = %7.0f ',a(5),a(6))
sprintf('Ohms = %5.3f  angle = %3.3f',abs(volts/amps),180*angle(volts/amps)/pi);
sprintf('Real Power = %5.3f  Imag Power =  %5.3f',real(volts*amps),imag(volts*amps))
sprintf('Vrms = %5.3f  Irms= =  %5.3f',abs(volts),abs(amps));
];

pt=title(pstr);

figure(2)
filtres=[1 i]*udpget(skt,'MeanRes');
vdf=20*log10(abs(filtres(1)));
idf=20*log10(abs(filtres(2)));
rf=ones(2,plotlen);
rf=[vdf 0; 0 idf]*rf;
pf=  plot(0:(plotlen-1),rf');
grid on
ylabel('dB re 1 volt or 1 amp');

pstrf=[ 'Filtered'
sprintf('Dft Res,freq = %7.0f Hz   DFT Count = %7.0f ',a(5),a(6))
sprintf('Ohms = %5.3f  angle = %3.3f',abs(filtres(3)/filtres(2)),180*angle(filtres(3)/filtres(2))/pi);
sprintf('Real Power = %5.3f  Imag Power =  %5.3f',real(filtres(3)),imag(filtres(3)))
sprintf('Vrms = %5.3f  Irms= =  %5.3f',sqrt(abs(filtres(1))),sqrt(abs(filtres())));
];

ptf=title(pstrf);

tic;
tp=toc;
tstep=0.01



while (min(size(kbhit(1)))<1)
a=udpget(skt,'DFT_Res');
volts=a(1:2)*[1;i];
amps=a(3:4)*[1;i];
%    amps=amps-(tfoc*volts);
%    volts=volts-(tfsc*amps);
f=a(5);
if (f<1e6)
  f=median(oldf);
else
  oldf(2:5)=oldf(1:4);
  oldf(1)=f;
endif


vd=20*log10(abs(volts));
id=20*log10(abs(amps));
  r=[ [vd id]' r(:,1:(plotlen-1))];
  set(p(1),'ydata',r(1,:)');
  set(p(2),'ydata',r(2,:)');
%  pstr=sprintf('Dft Res,freq = %7.0f Hz   DFT Count = %7.0f  \\n ohms = %5.2f  angle = %3.2f\\n',a(5),a(6),abs(volts/amps),180*angle(volts/amps)/pi);
  pstr=[
  sprintf('Dft Res,freq = %7.0f Hz   DFT Count = %7.0f ',a(5),a(6))
  sprintf('Ohms = %5.3f  angle = %3.3f',abs(volts/amps),180*angle(volts/amps)/pi);
  sprintf('Real Power = %5.3f  Imag Power =  %5.3f',real(volts*amps'),imag(volts*amps'))
  sprintf('Vrms = %5.3f  Irms= =  %5.3f',abs(volts),abs(amps));
  ];
  set(pt,'string',pstr);

  filtres=[1 i]*udpget(skt,'MeanRes');
  vdf=20*log10(abs(filtres(1)));
  idf=20*log10(abs(filtres(2)));
  rf=[ [vdf idf]' rf(:,1:(plotlen-1))];
  set(pf(1),'ydata',rf(1,:)');
  set(pf(2),'ydata',rf(2,:)');

pstrf=[
sprintf('Filtered')
sprintf('Dft Res,freq = %7.0f Hz   DFT Count = %7.0f ',a(5),a(6))
sprintf('Ohms = %5.3f  angle = %3.3f',abs(filtres(3)/filtres(2)),180*angle(filtres(3)/filtres(2))/pi);
sprintf('Real Power = %5.3f  Imag Power =  %5.3f',real(filtres(3)),imag(filtres(3)))
sprintf('Vrms = %5.3f  Irms= =  %5.3f',sqrt(abs(filtres(1))),sqrt(abs(filtres(2))));
];
  set(ptf,'string',pstrf);



  tp=tp+tstep;
  while (toc<tp) pause(0.001); end
end

udpset(skt,'DoTheDFT',0);

